﻿using System;
using System.Collections.Generic;
using System.Linq;

using VIRP.CRS.BO;
using VIRP.CRS.DAL;
using VIRP.EFR.UTIL;

namespace VIRP.CRS.BLL
{
    public static partial class STD_SIGNING_CLINICIANManger
    {
        #region Fields
        #endregion

        #region Properties
        #endregion

        #region Methods

        public static STD_SIGNING_CLINICIAN GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        {
            STD_SIGNING_CLINICIAN objReturn = null;
            var objDB = new STD_SIGNING_CLINICIANDB();

            objReturn = objDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, ID);

            return objReturn;
        }

        public static List<STD_SIGNING_CLINICIAN> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<STD_SIGNING_CLINICIAN> objReturn = null;
            var objDB = new STD_SIGNING_CLINICIANDB();

            objReturn = objDB.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);

            return objReturn;
        }

        public static List<KeyValuePair<int, string>> GetOrderedClinicians(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            var db = new STD_SIGNING_CLINICIANDB();

            var clinicians = db
                .GetItems(CURRENT_USER, CURRENT_REGISTRY_ID)
                .OrderBy(c => c.ID)
                .Select(c => new KeyValuePair<int, string>(c.ID, c.NAME))
                .ToList();

            var comparer = new KeyValueComparer();

            clinicians.Sort(comparer);

            return clinicians;
        }

        public static int Save(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_SIGNING_CLINICIAN objSave)
        {
            int objReturn = 0;
            var objDB = new STD_SIGNING_CLINICIANDB();

            objReturn = objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

            return objReturn;
        }

        public static bool Delete(string CURRENT_USER, int CURRENT_REGISTRY_ID, int ID)
        {
            bool objReturn = false;
            var objDB = new STD_SIGNING_CLINICIANDB();

            objReturn = objDB.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, ID);

            return objReturn;
        }

        public static bool Delete(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_SIGNING_CLINICIAN objDelete)
        {
            return Delete(CURRENT_USER, CURRENT_REGISTRY_ID, objDelete.ID);
        }

        #endregion
    }
}
